%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
% print tree
print_trees(Infile,Outfile):-
	see(Infile),
	tell(Outfile),
	print_trees1(1),
	told,
	seen.

print_trees1(Number):-
	read(Tree),
	(Tree==end_of_file;
	 (write('---TREE: '),
	  write(Number),
	  nl,
	  print_tree(Tree),
	  nl,
	  Number1 is Number+1,
	  print_trees1(Number1))).

print_tree(Tree):-!,
	print_tree0(Tree,0).

print_tree0([],_):-!.
print_tree0([Head|Tail],Count):-
	tab(Count),write(Head),nl,
	Count1 is Count+1,!,
	print_tree1(Tail,Count1).

print_tree1([],_):-!.
print_tree1([Head|Tail],Count):-
	((atom(Head),!,tab(Count),write(Head),nl);
	 print_tree0(Head,Count)),
	print_tree1(Tail,Count).

print_list_of_tree(Infile,Outfile):-
	see(Infile),
	tell(Outfile),
	read(List),
	print_list_of_trees1(List),
	told,
	seen.

print_list_of_tree([]):-!.
print_list_of_tree([Head|Tail]):-
	print_tree(Head),
	print_list_of_tree(Tail).
