%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
%
%           other_entry.pl
%
%       Record other entries --
%           a goto-accept-entry, an accept-entry, and error entries.
%
%       $Id: other_entry.pl,v 1.3 1993/12/28 07:00:33 imai Exp imai $
%
%       $Log: other_entry.pl,v $
% Revision 1.3  1993/12/28  07:00:33  imai
% Changed a basic design.
%     Modified entry clauses to execute an error handling after
%     the parser fails in all stacks for a state.
%
% Revision 1.2  1993/12/16  08:16:22  imai
% Modified error entry clauses.
%
%
%

other_entries(Start_symbol,Terminals,Accept_state_number):-
	nl,write('% goto accept entry'),nl,
	goto_accept_entry(Start_symbol,Accept_state_number),
	nl,write('% accept entry'),nl,
	accept_entry(Accept_state_number),
	nl,write('% error'),nl,
	error_entry(Terminals),
	nl,write('% unknown word entry'),nl,
	unknown_word_entry.

goto_accept_entry(Start_symbol,Accept_state_number):-
	write(Start_symbol),write('(_,'),
	write(Accept_state_number),write('):-!.'),nl.

accept_entry(Accept_state_number):-
	write('null_(_,'),write(Accept_state_number),
	write(',L,E,[(K,NOT)],_,NR1,NR2):-!,'),nl,
	tab(4),write('push('),write(Accept_state_number),
	write('-L-E,K,NR1,NR2),'),
	nl,tab(4),write('extract_number(L,NOT).').

error_entry([]):-!.
error_entry([Pt|Tail]):-
	write(Pt),write('_(_,S,L,E,[],_,NR1,NR2):-!,'),nl,
	tab(4),write('push(S-L-E,K,NR1,NR3),'),nl,
	tab(4),write('record_error_info(K,NR3,NR2).'),nl,
%	tab(4),write('record_shift_info(S-L-E,NR4,NR2).'),nl,
	error_entry(Tail).

unknown_word_entry :-
	write('uk(F,EP,Node,N,Posi,NR1,NR2):-'),nl,
	tab(4),write('uk0(EP,Node,N1,Posi,NR1,NR3),'),nl,
	tab(4),write('(N1=[],error_handling(F,uk,Node,N,NR3,NR2);N=N1,NR2=NR3).'),nl,
	write('uk0(_,[],[],NR1,NR2):-!, NR2=NR1.'),nl,
	write('uk0(EP,[S-L-E|T],N,Posi,NR1,NR2):-'),nl,
	tab(4),write('uk_(EP,S,L,E,N1,Posi,NR1,NR3),'),nl,
	tab(4),write('append(N1,N2,N),!,'),nl,
	tab(4),write('uk0(EP,T,N2,Posi,NR3,NR2).'),nl,
	write('uk_(_,S,L,E,[],_,NR1,NR2):-!,'),nl,
	tab(4),write('push(S-L-E,K,NR1,NR3),'),nl,
	tab(4),write('record_error_info(K,NR3,NR2).'),nl.
%	tab(4),write('record_shift_info(S-L-E,NR4,NR2).'),nl.

