%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
%
%           mkstart.pl
%
%       Make a start-file 'tmp.start' from the input sentence.
%
%       $Id$
%
%       $Log$
%
%

% Write a parsing clause to Outfile.
mkstart(Outfile):-
	findall(T,is_terminal(T),TSet),
	write(TSet),
        tell(Outfile),
	printstyle,
	makeclause1(TSet),
	makeclause2(TSet),
	told.

printstyle :-
	write('% The Style of these clauses are as follows.'),nl,
        write('% parse(Terminal,Arg2,Arg2,Arg3,Arg4,Arg5,NodRec1,NodRec2)'),nl,nl,nl.

makeclause1([]) :- 
%	format("otherwise.~n",[]).
	format("~n~n",[]),
	!.
makeclause1([T|TSet]) :-
	format("parse([~p],A1,A2,A3,A4,A5,NR1,NR2) :- ~n",[T]),
	format("    ~p(A1,A2,A3,A4,A5,NR1,NR2).~n",[T]),
	makeclause1(TSet).

makeclause2([]) :- !.
makeclause2([T|TSet]) :-
	format("parse([~p|IR],A1,A2,A3,NA4,A5,NR1,NR2) :- ~n",[T]),
	format("    ~p(A1,A2,A3,A4,A5,NR1,NR3),~n",[T]),
	format("    merge_node(A4,NA3),~n",[]),
	format("    NA1 = A1, NA2 = A2, NA5 is A5+1,~n",[]),
	format("    parse(IR,NA1,NA2,NA3,NA4,NA5,NR3,NR2).~n",[]),
	makeclause2(TSet).

mkstart1([],Number,Number):-!.
mkstart1([Symbol|Tail],Number,Number_end):-
	Number1 is Number+1,
	tab(4),write(Symbol),write('(n,n,N'),write(Number),
	write(',N'),write(Number1),write('p,'),write(Number),
	write('),!,'),nl,
	tab(4),write('merge_node(N'),write(Number1),write('p,N'),
	write(Number1),write('),!,'),nl,
%	tab(4),
%	write('write(user_output,'),write(Number1),
%	write('),ttynl,ttyflush,'),nl,
%	write('write(user_output,N'),
%	write(Number1),
%	write('),ttynl,ttyflush,'),nl,
	mkstart1(Tail,Number1,Number_end).
