%
% Copyright (C) 1996 Thanaruk Theeramunkong (ping@jaist.ac.jp)       
%                    Hiroki Imai            (imai@cs.titech.ac.jp)  
%                    Manabu Okumura         (oku@jaist.ac.jp)       
%                    Susumu Kunifuji        (kuni@jaist.ac.jp)      
%								     
%					       6 June 1996	     
%								     
% The file contains some specifications for RLRPAR          	     
%
% CFG only version

% if Lookahead is not variable,
% recorded(expand,[Lookahead,Rule_Number],_),
% else, list is [Rule_number]

:- dynamic expand_no_precedent/2.

clean_no_precedent:-
	\+ (recorded(expand,_,Key),erase(Key),fail).

already_expanded(Lookahead,Number):-
	((var(Lookahead),!,
	  recorded(expand,[Number],_));
	 recorded(expand,[Lookahead,Number],_)).

record_no_precedent(Lookahead,Number):-
	((var(Lookahead),!,
	  recorda(expand,[Number],_));
	 recorda(expand,[Lookahead,Number],_)).

list_expand(Eatens,Expand):-!,
        get_first_and_next(Eatens,First_and_next0),
	sort(First_and_next0,First_and_next1),
        list_expand_no_precedent(First_and_next1,Expand1),
	append(Eatens,Expand1,Expand2),
	sort(Expand2,Expand).

list_expand_no_precedent([],[]):-!.
list_expand_no_precedent([(Symbol,Next)|Tail],Expands):-!,
	expand_no_precedent(Symbol,Expands_no_next1),
	list_is_lookahead_var(Expands_no_next1,Next,Expands1),
	list_expand_no_precedent(Tail,Expands2),
	append(Expands1,Expands2,Expands).

% expand_no_precedent sort expands.
expand_no_precedent(Symbol,Expands):-
	clean_no_precedent,
	findall(Expand,
	        expand_no_precedent0(Symbol,_,Expand),
		Expands0),
	sort(Expands0,Expands),
	asserta((expand_no_precedent(Symbol,Expands):-!)).

expand_no_precedent0(Symbol,Next,Expand):-
	rule(Symbol,[Lookahead,Number,RHS]),
	is_lookahead_var(Lookahead,Next),
	\+ already_expanded(Lookahead,Number),
	record_no_precedent(Lookahead,Number),
	(Expand=(RHS,Lookahead,Number);
	 (first_and_next((RHS,Lookahead,_),Symbol1,Next1),
	  expand_no_precedent0(Symbol1,Next1,Expand))).
