/*
 *   Copyright (c) 2008, Ueda Laboratory LMNtal Group <lmntal@ueda.info.waseda.ac.jp>
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions are
 *   met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *
 *    3. Neither the name of the Ueda Laboratory LMNtal Group nor the
 *       names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package lavit.editor;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import lavit.Env;
import lavit.FrontEnd;
import lavit.Lang;
import lavit.runner.LmntalRunner;
import lavit.runner.SlimRunner;

@SuppressWarnings("serial")
public class EditorButtonPanel extends JPanel implements ActionListener
{
	private EditorPanel editorPanel;

	private LmntalRunner lmntalRunner;
	private SlimRunner slimRunner;

	private JPanel buttonPanel;
	public JButton lmntalButton;
	public JButton lmntalgButton;
	public JButton unyoButton;
	public JButton stateProfilerButton;
	public JButton slimButton;
	public JButton sviewerButton;
	public JButton svporButton;
	public JButton nullButton;
	public JButton killButton;

	public EditorButtonPanel(EditorPanel editorPanel){
		this.editorPanel = editorPanel;

		setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));

		//ボタン列
		buttonPanel = new JPanel(new GridLayout(2,4));

		lmntalButton = new JButton(Lang.m[11]);
		lmntalButton.addActionListener(this);
		buttonPanel.add(lmntalButton);

		lmntalgButton = new JButton(Lang.m[12]);
		lmntalgButton.addActionListener(this);
		buttonPanel.add(lmntalgButton);

		unyoButton = new JButton(Lang.m[13]);
		unyoButton.addActionListener(this);
		buttonPanel.add(unyoButton);

		stateProfilerButton = new JButton(Lang.m[21]);
		stateProfilerButton.addActionListener(this);
		buttonPanel.add(stateProfilerButton);

		slimButton = new JButton(Lang.m[14]);
		slimButton.addActionListener(this);
		buttonPanel.add(slimButton);

		sviewerButton = new JButton(Lang.m[15]);
		sviewerButton.addActionListener(this);
		buttonPanel.add(sviewerButton);

		//svporButton = new JButton("(POR)"+Lang.m[15]);
		svporButton = new JButton("");
		svporButton.addActionListener(this);
		buttonPanel.add(svporButton);

		/*
		sviewerlButton = new JButton("(LTL)"+Lang.m[15]);
		sviewerlButton.addActionListener(this);
		buttonPanel.add(sviewerlButton);
		*/
		//nullButton = new JButton();
		//buttonPanel.add(nullButton);

		killButton = new JButton(Lang.m[20]);
		killButton.addActionListener(this);
		buttonPanel.add(killButton);

		setAllEnable(true);
		add(buttonPanel);
	}

	public void setAllEnable(boolean enable){
		//nullButton.setEnabled(enable);

		lmntalButton.setEnabled(enable);
		lmntalgButton.setEnabled(enable);
		unyoButton.setEnabled(enable);
		slimButton.setEnabled(enable);
		sviewerButton.setEnabled(enable);
		svporButton.setEnabled(enable);
		stateProfilerButton.setEnabled(enable);

		killButton.setEnabled(!enable);
	}

	private void setButtonEnable(boolean enable){
		setAllEnable(enable);
		FrontEnd.mainFrame.toolTab.ltlPanel.setButtonsEnabled(enable);
	}

	public void actionPerformed(ActionEvent e) {
		JButton src = (JButton)e.getSource();

		if (src == lmntalButton) {

			if(editorPanel.isChanged()){
				editorPanel.fileSave();
			}

			setButtonEnable(false);

			FrontEnd.mainFrame.toolTab.setTab("System");

			FrontEnd.println("(LMNtal) Doing...");
			lmntalRunner = new LmntalRunner(Env.get("LMNTAL_OPTION"));
			lmntalRunner.run();
			(new Thread(new Runnable() { public void run() {
				while(lmntalRunner.isRunning()){
					FrontEnd.sleep(200);
				}
				FrontEnd.println("(LMNtal) Done! ["+(lmntalRunner.getTime()/1000.0)+"s]");
				lmntalRunner = null;
				javax.swing.SwingUtilities.invokeLater(new Runnable(){public void run() {
					setButtonEnable(true);
				}});
			}})).start();

		}else if (src == lmntalgButton) {

			if(editorPanel.isChanged()){
				editorPanel.fileSave();
			}

			setButtonEnable(false);

			FrontEnd.mainFrame.toolTab.setTab("System");

			FrontEnd.println("(LMNtal) Doing...");
			lmntalRunner = new LmntalRunner("-g "+Env.get("UNYO_OPTION"));
			lmntalRunner.run();
			(new Thread(new Runnable() { public void run() {
				while(lmntalRunner.isRunning()){
					FrontEnd.sleep(200);
				}
				FrontEnd.println("(LMNtal) Done!");
				lmntalRunner = null;
				javax.swing.SwingUtilities.invokeLater(new Runnable(){public void run() {
					setButtonEnable(true);
				}});
			}})).start();

		}
		else if (src == unyoButton)
		{
			if (editorPanel.isChanged())
			{
				editorPanel.fileSave();
			}
			FrontEnd.mainFrame.toolTab.setTab("System");
			FrontEnd.executeUnyo(FrontEnd.mainFrame.editorPanel.getFile());
		}
		else if (src == slimButton)
		{
			if (editorPanel.isChanged())
			{
				editorPanel.fileSave();
			}

			if (editorPanel.getFile().getName().endsWith(".il"))
			{
				FrontEnd.mainFrame.runILCodeOnSLIM();
			}
			else
			{
				setButtonEnable(false);

				FrontEnd.mainFrame.toolTab.setTab("System");

				FrontEnd.println("(SLIM) Doing...");
				slimRunner = new SlimRunner(Env.get("SLIM_OPTION"));
				slimRunner.run();
				(new Thread(new Runnable() { public void run() {
					while(slimRunner.isRunning()){
						FrontEnd.sleep(200);
					}
					FrontEnd.println("(SLIM) Done! ["+(slimRunner.getTime()/1000.0)+"s]");
					slimRunner = null;
					javax.swing.SwingUtilities.invokeLater(new Runnable(){public void run() {
						setButtonEnable(true);
					}});
				}})).start();
			}
		}
		else if (src == sviewerButton) {

			if(editorPanel.isChanged()){
				editorPanel.fileSave();
			}

			setButtonEnable(false);

			FrontEnd.mainFrame.toolTab.setTab("System");

			FrontEnd.println("(StateViewer) Doing...");
			String opt = "";
			if(Env.is("SLIM2")){
				opt = "--nd -t --dump-lavit "+Env.get("SV_OPTION");
			}else{
				opt = "--nd "+Env.get("SV_OPTION");
				if(!Env.get("SV_DEPTH_LIMIT").equals("unset")){
					opt += " --bfs_depth "+Env.get("SV_DEPTH_LIMIT");
				}
			}
			slimRunner = new SlimRunner(opt);
			slimRunner.setBuffering(true);
			slimRunner.run();
			(new Thread(new Runnable() { public void run() {
				while(slimRunner.isRunning()){
					FrontEnd.sleep(200);
				}
				FrontEnd.println("(SLIM) Done! ["+(slimRunner.getTime()/1000.0)+"s]");
				if(slimRunner.isSucceeded()){
					FrontEnd.mainFrame.toolTab.statePanel.start(slimRunner.getBufferString(),false);
				}
				slimRunner = null;
				javax.swing.SwingUtilities.invokeLater(new Runnable(){public void run() {
					setButtonEnable(true);
				}});
			}})).start();

		}else if (src == svporButton) {
			if (Env.isSet("CUSTOM_COMMAND"))
			{
				String cmd = Env.get("CUSTOM_COMMAND");
				cmd = cmd.replace("<FILE>", editorPanel.getFileName());
				System.out.println("Custom Command: " + cmd);
				try
				{
					ProcessBuilder pb = new ProcessBuilder(cmd.split("\\s+"));
					pb.redirectErrorStream(true);
					Process p = pb.start();
					BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
					String line;
					while ((line = reader.readLine()) != null)
					{
						System.out.println(line);
					}
				}
				catch (IOException e1)
				{
					e1.printStackTrace();
				}
			}
			/*
			if(editorPanel.isChanged()){
				editorPanel.fileSave();
			}

			setButtonEnable(false);

			FrontEnd.mainFrame.toolTab.setTab("System");

			FrontEnd.println("(StateViewer) Doing...");
			slimRunner = new SlimRunner("--por "+Env.get("SV_OPTION"));
			slimRunner.setBuffering(true);
			slimRunner.run();
			(new Thread(new Runnable() { public void run() {
				while(slimRunner.isRunning()){
					FrontEnd.sleep(200);
				}
				if(slimRunner.isSuccess()){
					FrontEnd.mainFrame.toolTab.statePanel.start(slimRunner.getBufferString(),false);
				}
				slimRunner = null;
				javax.swing.SwingUtilities.invokeLater(new Runnable(){public void run() {
					setButtonEnable(true);
				}});
			}})).start();
			*/


			//FrontEnd.println(SlimRunner.checkRun()?"ok":"ng");
			//FrontEnd.reboot();


/*
		}else if (src == sviewerlButton) {

			if(editorPanel.isChanged()){
				editorPanel.fileSave();
			}

			setButtonEnable(false);

			FrontEnd.mainFrame.toolTab.setTab("System");

			FrontEnd.println("(StateViewer) Doing...");
			slimRunner = new SlimRunner("--ltl_nd --hideruleset");
			slimRunner.setBuffering(true);
			slimRunner.run();
			(new Thread(new Runnable() { public void run() {
				while(slimRunner.isRunning()){
					FrontEnd.sleep(200);
				}
				if(slimRunner.isSuccess()){
					FrontEnd.mainFrame.toolTab.statePanel.start(slimRunner.getBufferString());
				}
				slimRunner = null;
				javax.swing.SwingUtilities.invokeLater(new Runnable(){public void run() {
					setButtonEnable(true);
				}});
			}})).start();
*/

		}else if (src == stateProfilerButton) {


			if(editorPanel.isChanged()){
				editorPanel.fileSave();
			}

			setButtonEnable(false);

			FrontEnd.mainFrame.toolTab.setTab("StateProfiler");

			FrontEnd.println("(StateProfiler) Doing...");
			if(Env.is("SLIM2")){
				slimRunner = new SlimRunner("--nd --dump-inc --dump-lavit");
			}else{
				slimRunner = new SlimRunner("--nd_dump --hideruleset");
			}
			slimRunner.setOutputGetter(FrontEnd.mainFrame.toolTab.stateProfilePanel);

			slimRunner.run();
			(new Thread(new Runnable() { public void run() {
				while(slimRunner.isRunning()){
					FrontEnd.sleep(200);
				}
				FrontEnd.println("(StateProfiler) Done!");
				slimRunner = null;
				SwingUtilities.invokeLater(new Runnable(){public void run() {
					setButtonEnable(true);
				}});
			}})).start();


		}
		else if (src == killButton)
		{
			if (lmntalRunner != null) lmntalRunner.kill();
			if (slimRunner != null) slimRunner.kill();
			FrontEnd.mainFrame.killILRunner();
			FrontEnd.mainFrame.toolTab.ltlPanel.killLtlSlimRunner();
			FrontEnd.abortAllProcessTasks();
			FrontEnd.errPrintln("Kill");
		}
	}

}
