/* C code produced by gperf version 2.1 (K&R C version) */
/* Command-line: gperf -D -l -c -C -a -f -o -k1,2,4,$ -n -p -S1 -g -t -N is_reserved_word wrd.gperf  */


/*
 * wrd.gperf -- keyfile for gperf. This file is part of xwrdplay.
 *
 * Copyright (C) 1996,1997 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Id: wrd.gperf,v 1.3 1997-07-27 04:16:34+09 satoshi Exp $ */
struct resword { const char* name; token_type token; };

#define MIN_WORD_LENGTH 3
#define MAX_WORD_LENGTH 15
#define MIN_HASH_VALUE 6
#define MAX_HASH_VALUE 165
/*
   48 keywords
  160 is the maximum key range
*/

#ifdef __GNUC__
inline
#endif
static int
hash (register const char *str, register int len)
{
  static const unsigned char hash_table[] =
    {
     165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
     165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
     165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
     165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
     165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
     165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
     165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
     165,  30, 165, 165, 165, 165, 165, 165, 165, 165,
     165, 165, 165, 165, 165, 165, 165, 165, 165, 165,
     165, 165, 165, 165, 165, 165, 165,   1, 165,  17,
      15,   0,  51,  25,  10,  25, 165,  20,   0,  41,
      35,   5,  56, 165,  20,   6,  47, 165,  30,  15,
      36,  30, 165, 165, 165, 165, 165, 165,
    };
  register int hval = 0;

  switch (len)
    {
      default:
      case 4:
        hval += hash_table[str[3]];
      case 3:
      case 2:
        hval += hash_table[str[1]];
      case 1:
        hval += hash_table[str[0]];
    }
  return hval + hash_table[str[len - 1]] ;
}

#ifdef __GNUC__
inline
#endif
const struct resword *
is_reserved_word (register const char *str, register int len)
{

  static const struct resword  wordlist[] =
    {
      {"locate", 		tLOCATE},
      {"esc", 		tESC},
      {"line", 		tLINE},
      {"regsave", 	tREGSAVE},
      {"scroll", 		tSCROLL},
      {"remark", 		tREMARK},
      {"vsres", 		tVSRES},
      {"color", 		tCOLOR},
      {"gsc", 		tGSC},
      {"end", 		tEND},
      {"fade", 		tFADE},
      {"gcls", 		tGCLS},
      {"pal", 		tPAL},
      {"screen", 		tSCREEN},
      {"gline", 		tGLINE},
      {"rem", 		tREM},
      {"gcircle", 	tGCIRCLE},
      {"gon", 		tGON},
      {"mag", 		tMAG},
      {"exec", 		tEXEC},
      {"wmode", 		tWMODE},
      {"pload", 		tPLOAD},
      {"tscrl", 		tTSCRL},
      {"tcls", 		tTCLS},
      {"path", 		tPATH},
      {"gmode", 		tGMODE},
      {"vsget", 		tVSGET},
      {"gscreen", 	tGSCREEN},
      {"ton", 		tTON},
      {"inkey", 		tINKEY},
      {"gmove", 		tGMOVE},
      {"tmode", 		tTMODE},
      {"palchg		tPALCHG", },
      {"palrev", 		tPALREV},
      {"offset", 		tOFFSET},
      {"wait", 		tWAIT},
      {"rest", 		tREST},
      {"midi", 		tMIDI},
      {"loop", 		tLOOP},
      {"ginit", 		tGINIT},
      {"fontr", 		tFONTR},
      {"startup", 	tSTARTUP},
      {"vcopy", 		tVCOPY},
      {"xcopy", 		tXCOPY},
      {"textdot", 	tTEXTDOT},
      {"fontm", 		tFONTM},
      {"fontp", 		tFONTP},
      {"stop", 		tSTOP},
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          if (key <= 165)
            {
              const struct resword  *resword; 

              switch (key - 6)
                {
                case    0:
                  resword = &wordlist[0]; break;
                case   17:
                  resword = &wordlist[1]; break;
                case   19:
                  resword = &wordlist[2]; break;
                case   20:
                  resword = &wordlist[3]; break;
                case   22:
                  resword = &wordlist[4]; break;
                case   35:
                  resword = &wordlist[5]; break;
                case   36:
                  resword = &wordlist[6]; break;
                case   41:
                  resword = &wordlist[7]; break;
                case   42:
                  resword = &wordlist[8]; break;
                case   44:
                  resword = &wordlist[9]; break;
                case   46:
                  resword = &wordlist[10]; break;
                case   48:
                  resword = &wordlist[11]; break;
                case   51:
                  resword = &wordlist[12]; break;
                case   52:
                  resword = &wordlist[13]; break;
                case   54:
                  resword = &wordlist[14]; break;
                case   55:
                  resword = &wordlist[15]; break;
                case   56:
                  resword = &wordlist[16]; break;
                case   59:
                  resword = &wordlist[17]; break;
                case   61:
                  resword = &wordlist[18]; break;
                case   64:
                  resword = &wordlist[19]; break;
                case   65:
                  resword = &wordlist[20]; break;
                case   66:
                  resword = &wordlist[21]; break;
                case   67:
                  resword = &wordlist[22]; break;
                case   70:
                  resword = &wordlist[23]; break;
                case   71:
                  resword = &wordlist[24]; break;
                case   75:
                  resword = &wordlist[25]; break;
                case   77:
                  resword = &wordlist[26]; break;
                case   80:
                  resword = &wordlist[27]; break;
                case   81:
                  resword = &wordlist[28]; break;
                case   84:
                  resword = &wordlist[29]; break;
                case   90:
                  resword = &wordlist[30]; break;
                case   97:
                  resword = &wordlist[31]; break;
                case   98:
                  resword = &wordlist[32]; break;
                case  101:
                  resword = &wordlist[33]; break;
                case  103:
                  resword = &wordlist[34]; break;
                case  104:
                  resword = &wordlist[35]; break;
                case  108:
                  resword = &wordlist[36]; break;
                case  110:
                  resword = &wordlist[37]; break;
                case  111:
                  resword = &wordlist[38]; break;
                case  116:
                  resword = &wordlist[39]; break;
                case  117:
                  resword = &wordlist[40]; break;
                case  123:
                  resword = &wordlist[41]; break;
                case  127:
                  resword = &wordlist[42]; break;
                case  133:
                  resword = &wordlist[43]; break;
                case  135:
                  resword = &wordlist[44]; break;
                case  138:
                  resword = &wordlist[45]; break;
                case  153:
                  resword = &wordlist[46]; break;
                case  159:
                  resword = &wordlist[47]; break;
                default: return 0;
                }
              if (*str == *resword->name && !strncmp (str + 1, resword->name + 1, len - 1))
                return resword;
              return 0;
            }
         }
    }
  return 0;
}
