/*
//	Mag.cc -- MAG format image handling
//
//		created    in 3/2/1993
//		revised    in 2/12/1994
*/

/*
 * modified by Satoshi KURAMOCHI 1996,1997
 * $Id: magfile.cc,v 1.3 1997-12-20 20:10:07+09 satoshi Exp $
 */
#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <ctype.h>
#include	"magfile.h"

const unsigned char MagFile::BitField[8] =
  { 0x80, 0x40, 0x20, 0x10, 0x8, 0x4, 0x2, 0x1 };
const int MagFile::OriginalDX[16] =
  { 0, 1, 2, 4, 0, 1, 0, 1, 2, 0, 1, 2, 0, 1, 2, 0 };
const int MagFile::OriginalDY[16] =
  { 0, 0, 0, 0, 1, 1, 2, 2, 2, 4, 4, 4, 8, 8, 8, 16 };

void MagFile::decode( char *FlagA, char *FlagB )
{
    int 	DX[32], DY[32];
    char        Flag;
    unsigned char       c0, c1;
    int 	Width8;
    int         x, xx, y, gy;
    int         x8, xp, i;

    for ( i = 0; i < 16; i++ ) {
	DX[i] = OriginalDX[i];
	DY[i] = OriginalDY[i];
    }
    Width8 = (width-1) >> 3;
    for (i = 0; i < width; i++)
        FlagBuffer[i] = 0;
    xx = 0;
    gy = 0;
    for ( i = 0; i < 16; i++ )
	DY[i] = DY[i] * width;
    for ( y = 0; y < height; y++ ) {
	for ( x = 0; x <= Width8; x++, xx++ ) {
	    xx &= 7;
	    x8 = x * 8;
	    if ( *FlagA & BitField[xx] )
		FlagBuffer[x] ^= *FlagB++;
	    if ( xx == 7 )
		FlagA++;
	    Flag = (FlagBuffer[x] >> 4) & 0x0f;
	    if ( Flag == 0 ) {
		c0 = fgetc (fp);
		c1 = fgetc (fp);
		Screen[x8 + gy] = (c0 >> 4) & 0x0f;
		Screen[x8 + gy + 1] = c0 & 0x0f;
		Screen[x8 + gy + 2] = (c1 >> 4) & 0x0f;
		Screen[x8 + gy + 3] = c1 & 0x0f;
	    }
	    else {
		xp = x8 - DX[Flag] * 4;
		Screen[x8 + gy] = Screen[xp + gy - DY[Flag]];
		Screen[x8 + gy + 1] = Screen[xp + gy - DY[Flag] + 1];
		Screen[x8 + gy + 2] = Screen[xp + gy - DY[Flag] + 2];
		Screen[x8 + gy + 3] = Screen[xp + gy - DY[Flag] + 3];
	    }
	    Flag = FlagBuffer[x] & 0x0f;
	    if ( Flag == 0 ) {
		c0 = fgetc (fp);
		c1 = fgetc (fp);
		Screen[x8 + gy + 4] = (c0 >> 4) & 0x0f;
		Screen[x8 + gy + 5] = c0 & 0x0f;
		Screen[x8 + gy + 6] = (c1 >> 4) & 0x0f;
		Screen[x8 + gy + 7] = c1 & 0x0f;
	    }
	    else {
		xp = x8 + 4 - DX[Flag] * 4;
		Screen[x8 + gy + 4] = Screen[xp + gy - DY[Flag] ];
		Screen[x8 + gy + 5] = Screen[xp + gy - DY[Flag] + 1];
		Screen[x8 + gy + 6] = Screen[xp + gy - DY[Flag] + 2];
		Screen[x8 + gy + 7] = Screen[xp + gy - DY[Flag] + 3];
	    }
	}
	gy += width;
    }
}

void MagFile::decode256( char *FlagA, char *FlagB )
{
    int 	DX[32], DY[32];
    char        Flag;
    unsigned char       c0, c1;
    int 	Width8;
    int         x, xx, y, gy;
    int         x8, yp, xp, i;

    for ( i = 0; i < 16; i++ ) {
	DX[i] = OriginalDX[i];
	DY[i] = OriginalDY[i];
    }
    Width8 = (width-1) >> 2;
    for (i = 0; i < width; i++)
        FlagBuffer[i] = 0;
    xx = 0;
    gy = 0;
    for ( i = 0; i < 16; i++ )
	DY[i] = DY[i] * width;
    for ( y = 0; y < height; y++ ) {
	for ( x = 0; x <= Width8; x++, xx++ ) {
	    xx &= 7;
	    x8 = x * 4;
	    if ( *FlagA & BitField[xx] )
		FlagBuffer[x] ^= *FlagB++;
	    if ( xx == 7 )
		FlagA++;
	    Flag = (FlagBuffer[x] >> 4) & 0x0f;
	    if ( Flag == 0 ) {
		c0 = fgetc (fp);
		c1 = fgetc (fp);
		Screen[x8 + gy] = c0 & 0xff;
		Screen[x8 + gy + 1] = c1 & 0xff;
	    }
	    else {
		yp = (y - DY[Flag]) & 15;
		xp = x8 - DX[Flag] * 2;
		Screen[x8 + gy] = Screen[xp + gy - DY[Flag]];
		Screen[x8 + gy + 1] = Screen[xp + gy - DY[Flag] + 1];
	    }
	    Flag = FlagBuffer[x] & 0x0f;
	    if ( Flag == 0 ) {
		c0 = fgetc (fp);
		c1 = fgetc (fp);
		Screen[x8 + gy + 2] = c0 & 0xff;
		Screen[x8 + gy + 3] = c1 & 0xff;
	    }
	    else {
		yp = (y - DY[Flag]) & 15;
		xp = x8 + 2 - DX[Flag] * 2;
		Screen[x8 + gy + 2] = Screen[xp + gy - DY[Flag]];
		Screen[x8 + gy + 3] = Screen[xp + gy - DY[Flag] + 1];
	    }
	}
	gy += width;
    }
}

void MagFile::readHeader(void)
{
    int 	i;

    header.Head = fgetc (fp);
    header.Machine = fgetc (fp);
    header.MachineDependence = fgetc (fp);
    header.ScreenMode = fgetc (fp);
    header.Left = readWord();
    header.Top = readWord();
    header.Right = readWord();
    header.Bottom = readWord();
    header.FlagAOffset = readDWord();
    header.FlagBOffset = readDWord();
    header.FlagBSize = readDWord();
    header.PixelOffset = readDWord();
    header.PixelSize = readDWord();
    if ( header.ScreenMode & 1 )
	DoubleLine = 1;
    else
	DoubleLine = 0;
    if ( header.ScreenMode & 0x80 ) {
	MaxColor = 256;
	DoubleLine = 0;
    }
    else
	MaxColor = 16;
    for ( i = 0; i < MaxColor; i++ ) {
        Green[i] = fgetc (fp);
        Red[i] = fgetc (fp);
        Blue[i] = fgetc (fp);
    }
    width = (header.Right & 0xff8) - (header.Left & 0xff8) + 8;
    height = header.Bottom - header.Top + 1;
    if ( DoubleLine )
	height = height * 2;
    size = height*width;
    allocateScreen(width, height);
    if ( (FlagA = (char*)malloc(header.FlagBOffset - header.FlagAOffset + 256)) == NULL )
	error ("%s: Insufficient memory");
    if ( (FlagB = (char*)malloc(header.PixelOffset - header.FlagBOffset + 256)) == NULL )
	error ("%s: Insufficient memory");
    fread( FlagA, 1, header.FlagBOffset - header.FlagAOffset, fp );
    fread( FlagB, 1, header.PixelOffset - header.FlagBOffset, fp );
}

int16 MagFile::readWord(void)
{
    int 	c0, c1;

    c0 = fgetc (fp);
    c1 = fgetc (fp);
    return (int16)(c0 | (c1 << 8));
}

uint32 MagFile::readDWord(void)
{
    uint32 	c0, c1, c2, c3;

    c0 = fgetc (fp);
    c1 = fgetc (fp);
    c2 = fgetc (fp);
    c3 = fgetc (fp);
    return (uint32)(c0 | (c1 << 8) | (c2 << 16) | (c3 << 24));
}

void MagFile::load(void)
{
    int 	c, x, y, i, j;

    if(name == NULL)
      return;
    if((fp = fopen(name, "rb" )) == NULL ) {
      error ("%s: No such file");
      return;
    }
    if ( fgetc (fp) != 'M' || fgetc (fp) != 'A'
	 || fgetc (fp) != 'K' || fgetc (fp) != 'I'
	 || fgetc (fp) != '0' || fgetc (fp) != '2'
	 || fgetc (fp) != ' ' || fgetc (fp) != ' ' )
	error ("%s: Is not mag format");
    for ( ; (c = fgetc (fp)) != 0x1a && c != EOF; );
    readHeader();
    if ( (FlagBuffer = (char*)malloc (width + 16)) == NULL )
	error ("%s: Insufficient memory");
    if ( MaxColor == 16 )
	decode( FlagA, FlagB );
    else
	decode256( FlagA, FlagB );
    if ( fp != stdin )
	fclose(fp);
    free (FlagA);
    free (FlagB);
    free (FlagBuffer);
    MaxColorGuaranteed = MaxColor;
    if ( DoubleLine ) {
	for ( y = height / 2 - 1; y >= 0; y-- ) {
	    i = y * 2 * width;
	    j = y * width;
	    for ( x = width - 1; x >= 0; x-- ) {
		Screen[x + i] = Screen[x + j];
		Screen[x + i + width] = Screen[x + j];
	    }
	}
    }
}

#if 0
void MagFile::save(void)
{
    int 	i, j, HalfSize, FlagWidth, x, y;
    int16	Color[256 + 16];
    int 	DX[32], DY[32];
    int 	FlagASize, FlagBSize, PixelSize;

    if(name == NULL)
      return;
    if ((fp = fopen( File, "wb" )) == NULL ) {
	error ("%s: Cannot create");
	return;
    }
    MaxColor = 0;
    HalfSize = size / 2;
    for ( i = 0; i < HalfSize; i++ ) {
	for ( j = 0; j < MaxColor; j++ ) {
	    if ( Screen[i] == Color[j] ) {
		Screen[i] = j;
		break;
	    }
	}
	if ( j == MaxColor ) {
	    Color[MaxColor] = Screen[i];
	    Screen[i] = MaxColor;
	    MaxColor++;
	    if ( MaxColor > 256 )
		error ("%s: Too many colors for mag format");
	}
    }
    MaxColorGuaranteed = MaxColor;
    if ( MaxColorGuaranteed <= 16 ) {
	for ( i = 0; i < 16; i++ ) {
	    DX[i] = OriginalDX[i] * 4;
	    DY[i] = OriginalDY[i];
	}
	FlagWidth = (width + 7) / 8;
	MaxColor = 16;
	if ( (Flag = (char*)malloc (FlagWidth * height + 32)) == NULL )
	    error ("%s: Insufficient memory");
	PixelSize = 0;
	for ( y = 0; y < height; y++ ) {
	    for ( x = 0; x < width; ) {
#define	Try1(Number)	\
		if ( x - DX[Number] >= 0 && y - DY[Number] >= 0 ) {\
		    i = x - DX[Number] + (y - DY[Number]) * width;\
		    if ( Screen[x + y * width] == Screen[i]\
			 && Screen[x + y * width + 1] == Screen[i + 1]\
			 && Screen[x + y * width + 2] == Screen[i + 2]\
			 && Screen[x + y * width + 3] == Screen[i + 3] ) {\
			Flag[x / 8 + y * FlagWidth] = Number << 4;\
			goto Next1; } }
		Try1 (1) Try1 (4) Try1 (5) Try1 (6)
		Try1 (7) Try1 (9) Try1 (10) Try1 (2)
		Try1 (8) Try1 (11) Try1 (12) Try1 (13)
		Try1 (14) Try1 (3) Try1 (15);
		Flag[x / 8 + y * FlagWidth] = 0;
		PixelSize += 2;
	    Next1:
		x += 4;
#define	Try2(Number)	\
		if ( x - DX[Number] >= 0 && y - DY[Number] >= 0 ) {\
		    i = x - DX[Number] + (y - DY[Number]) * width;\
		    if ( Screen[x + y * width] == Screen[i]\
			 && Screen[x + y * width + 1] == Screen[i + 1]\
			 && Screen[x + y * width + 2] == Screen[i + 2]\
			 && Screen[x + y * width + 3] == Screen[i + 3] ) {\
			Flag[x / 8 + y * FlagWidth] |= Number;\
			goto Next2; } }
		Try2 (1) Try2 (4) Try2 (5) Try2 (6)
		Try2 (7) Try2 (9) Try2 (10) Try2 (2)
		Try2 (8) Try2 (11) Try2 (12) Try2 (13)
		Try2 (14) Try2 (3) Try2 (15);
		PixelSize += 2;
	    Next2:
		x += 4;
	    }
	}
	for ( y = height - 1; y >= 1; y-- ) {
	    for ( x = 0; x < FlagWidth; x++ ) {
		Flag[x + y * FlagWidth] ^= Flag[x + y * FlagWidth - FlagWidth];
	    }
	}
	if ( (FlagA = (char*)malloc (FlagWidth * height + 128)) == NULL )
	    error ("%s: Insufficient memory");
	for ( i = 0; i < FlagWidth * height; i++ )
	    FlagA[i] = 0;
	FlagASize = FlagBSize = 0;
	i = 0;
	for ( y = 0; y < height; y++ ) {
	    for ( x = 0; x < FlagWidth; x++ ) {
		if ( Flag[i] != 0 ) {
		    FlagA[FlagASize >> 3] |= BitField[FlagASize & 7];
		    FlagBSize++;
		}
		FlagASize++;
		i++;
	    }
	}
	FlagASize = (FlagASize + 7) / 8;
	if ( FlagASize & 1 )
	    FlagASize++;
	if ( FlagBSize & 1 )
	    FlagBSize++;
	if ( (FlagB = (char*)malloc (FlagBSize + 16)) == NULL )
	    error ("%s: Insufficient memory");
	fputs( "MAKI02  UNIX012345678901234567\x1a", fp );
	fputc( 0, fp ); fputc( 0x9a, fp ); fputc( 0xab, fp ); fputc( 0, fp );
	writeWord (0);
	writeWord (0);
	writeWord (FlagWidth * 8 - 1);
	writeWord (height - 1);
	writeDWord (32 + 48);
	writeDWord (32 + 48 + FlagASize);
	writeDWord (FlagBSize);
	writeDWord (32 + 48 + FlagASize + FlagBSize);
	writeDWord (PixelSize);
	for ( i = 0; i < 16; i++ ) {
	    fputc( (Color[i] >> 10) << 3, fp );
	    fputc( ((Color[i] >> 5) & 0x1f) << 3, fp );
	    fputc( (Color[i] & 0x1f) << 3, fp );
	}
	fwrite( FlagA, 1, FlagASize, fp );
	i = 0;
	j = 0;
	for ( y = 0; y < height; y++ ) {
	    for ( x = 0; x < FlagWidth; x++ ) {
		if ( Flag[i] != 0 )
		    FlagB[j++] = Flag[i];
		i++;
	    }
	}
	fwrite( FlagB, 1, FlagBSize, fp );
	if ( (FlagBuffer = (char*)malloc (width + 16)) == NULL )
	    error ("%s: Insufficient memory");
	writeImage( FlagA, FlagB );
	free (Flag);
	free (FlagA);
	free (FlagB);
	free (FlagBuffer);
    }
    else {
	for ( i = 0; i < 16; i++ ) {
	    DX[i] = OriginalDX[i] * 2;
	    DY[i] = OriginalDY[i];
	}
	FlagWidth = (width + 3) / 4;
	if ( FlagWidth & 1 )
	    FlagWidth++;
	MaxColor = 256;
	if ( (Flag = (char*)malloc (FlagWidth * height + 32)) == NULL )
	    error ("%s: Insufficient memory");
	PixelSize = 0;
	for ( y = 0; y < height; y++ ) {
	    for ( x = 0; x < width; ) {
#define	Try3(Number)	\
		if ( x - DX[Number] >= 0 && y - DY[Number] >= 0 ) {\
		    i = x - DX[Number] + (y - DY[Number]) * width;\
		    if ( Screen[x + y * width] == Screen[i]\
			 && Screen[x + y * width + 1] == Screen[i + 1] ) {\
			Flag[x / 4 + y * FlagWidth] = Number << 4;\
			goto Next3; } }
		Try3 (1) Try3 (4) Try3 (5) Try3 (6)
		Try3 (7) Try3 (9) Try3 (10) Try3 (2)
		Try3 (8) Try3 (11) Try3 (12) Try3 (13)
		Try3 (14) Try3 (3) Try3 (15);
		Flag[x / 4 + y * FlagWidth] = 0;
		PixelSize += 2;
	    Next3:
		x += 2;
#define	Try4(Number)	\
		if ( x - DX[Number] >= 0 && y - DY[Number] >= 0 ) {\
		    i = x - DX[Number] + (y - DY[Number]) * width;\
		    if ( Screen[x + y * width] == Screen[i]\
			 && Screen[x + y * width + 1] == Screen[i + 1] ) {\
			Flag[x / 4 + y * FlagWidth] |= Number;\
			goto Next4; } }
		Try4 (1) Try4 (4) Try4 (5) Try4 (6)
		Try4 (7) Try4 (9) Try4 (10) Try4 (2)
		Try4 (8) Try4 (11) Try4 (12) Try4 (13)
		Try4 (14) Try4 (3) Try4 (15);
		PixelSize += 2;
	    Next4:
		x += 2;
	    }
	}
	for ( y = height - 1; y >= 1; y-- ) {
	    for ( x = 0; x < FlagWidth; x++ ) {
		Flag[x + y * FlagWidth] ^= Flag[x + y * FlagWidth - FlagWidth];
	    }
	}
	if ( (FlagA = (char*)malloc (FlagWidth * height + 128)) == NULL )
	    error ("%s: Insufficient memory");
	for ( i = 0; i < FlagWidth * height; i++ )
	    FlagA[i] = 0;
	FlagASize = FlagBSize = 0;
	i = 0;
	for ( y = 0; y < height; y++ ) {
	    for ( x = 0; x < FlagWidth; x++ ) {
		if ( Flag[i] != 0 ) {
		    FlagA[FlagASize >> 3] |= BitField[FlagASize & 7];
		    FlagBSize++;
		}
		FlagASize++;
		i++;
	    }
	}
	FlagASize = (FlagASize + 7) / 8;
	if ( FlagASize & 1 )
	    FlagASize++;
	if ( FlagBSize & 1 )
	    FlagBSize++;
	if ( (FlagB = (char*)malloc (FlagBSize + 16)) == NULL )
	    error ("%s: Insufficient memory");
	fputs( "MAKI02  UNIX012345678901234567\x1a", fp );
	fputc( 0, fp ); fputc( 0x9a, fp ); fputc( 0xab, fp ); fputc( 0x80, fp );
	writeWord (0);
	writeWord (0);
	writeWord (FlagWidth * 4 - 1);
	writeWord (height - 1);
	writeDWord (32 + 768);
	writeDWord (32 + 768 + FlagASize);
	writeDWord (FlagBSize);
	writeDWord (32 + 768 + FlagASize + FlagBSize);
	writeDWord (PixelSize);
	for ( i = 0; i < 256; i++ ) {
	    fputc( (Color[i] >> 10) << 3, fp );
	    fputc( ((Color[i] >> 5) & 0x1f) << 3, fp );
	    fputc( (Color[i] & 0x1f) << 3, fp );
	}
	fwrite( FlagA, 1, FlagASize, fp );
	i = 0;
	j = 0;
	for ( y = 0; y < height; y++ ) {
	    for ( x = 0; x < FlagWidth; x++ ) {
		if ( Flag[i] != 0 )
		    FlagB[j++] = Flag[i];
		i++;
	    }
	}
	fwrite( FlagB, 1, FlagBSize, fp );
	if ( (FlagBuffer = (char*)malloc (width + 16)) == NULL )
	    error ("%s: Insufficient memory");
	writeImage256( FlagA, FlagB );
	free (Flag);
	free (FlagA);
	free (FlagB);
	free (FlagBuffer);
    }
    if ( fp != stdout )
	fclose (fp);
}

void MagFile::writeWord( int16 c )
{
    fputc( c & 0xff, fp );
    fputc( (c >> 8) & 0xff, fp );
}

void MagFile::writeDWord( uint32 c )
{
    fputc( c & 0xff, fp );
    fputc( (c >> 8) & 0xff, fp );
    fputc( (c >> 16) & 0xff, fp );
    fputc( (c >> 24) & 0xff, fp );
}

void MagFile::writeImage( char *FlagA, char *FlagB )
{
    int 	DX[32], DY[32];
    char        Flag;
    int 	Width8;
    int         x, xx, y, gy;
    int         x8, i;

    for ( i = 0; i < 16; i++ ) {
	DX[i] = OriginalDX[i];
	DY[i] = OriginalDY[i];
    }
    Width8 = (width-1) >> 3;
    for (i = 0; i < width; i++)
        FlagBuffer[i] = 0;
    xx = 0;
    gy = 0;
    for ( i = 0; i < 16; i++ )
	DY[i] = DY[i] * width;
    for ( y = 0; y < height; y++ ) {
	for ( x = 0; x <= Width8; x++, xx++ ) {
	    xx &= 7;
	    x8 = x * 8;
	    if ( *FlagA & BitField[xx] )
		FlagBuffer[x] ^= *FlagB++;
	    if ( xx == 7 )
		FlagA++;
	    Flag = (FlagBuffer[x] >> 4) & 0x0f;
	    if ( Flag == 0 ) {
		fputc( (Screen[x8 + gy] << 4) | Screen[x8 + gy + 1], fp );
		fputc( (Screen[x8 + gy + 2] << 4) | Screen[x8 + gy + 3], fp );
	    }
	    Flag = FlagBuffer[x] & 0x0f;
	    if ( Flag == 0 ) {
		fputc( (Screen[x8 + gy + 4] << 4) | Screen[x8 + gy + 5], fp );
		fputc( (Screen[x8 + gy + 6] << 4) | Screen[x8 + gy + 7], fp );
	    }
	}
	gy += width;
    }
}

void MagFile::writeImage256( char *FlagA, char *FlagB )
{
    int 	DX[32], DY[32];
    char        Flag;
    int 	Width8;
    int         x, xx, y, gy;
    int         x8, i;

    for ( i = 0; i < 16; i++ ) {
	DX[i] = OriginalDX[i];
	DY[i] = OriginalDY[i];
    }
    Width8 = (width + 3) / 4;
    if ( Width8 & 1 )
	Width8++;
    Width8--;
    for (i = 0; i < width; i++)
        FlagBuffer[i] = 0;
    xx = 0;
    gy = 0;
    for ( i = 0; i < 16; i++ )
	DY[i] = DY[i] * width;
    for ( y = 0; y < height; y++ ) {
	for ( x = 0; x <= Width8; x++, xx++ ) {
	    xx &= 7;
	    x8 = x * 4;
	    if ( *FlagA & BitField[xx] )
		FlagBuffer[x] ^= *FlagB++;
	    if ( xx == 7 )
		FlagA++;
	    Flag = (FlagBuffer[x] >> 4) & 0x0f;
	    if ( Flag == 0 ) {
		fputc( Screen[x8 + gy], fp );
		fputc( Screen[x8 + gy + 1], fp );
	    }
	    Flag = FlagBuffer[x] & 0x0f;
	    if ( Flag == 0 ) {
		fputc( Screen[x8 + gy + 2], fp );
		fputc( Screen[x8 + gy + 3], fp );
	    }
	}
	gy += width;
    }
}
#endif /* 0 */
