/*
 * filelist.h -- file list handling
 *
 * Copyright (C) 1997,1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: filelist.h,v 1.5 1998-02-12 11:20:16+09 satoshi Exp $

#ifndef _FILELIST_H_
#define _FILELIST_H_

struct Options {
  int play_sb, play_gus, play_ext;
  int verbose;
  int chanmask;
  int dochan;
  int force8bit;
  int wantopl3;
  int useprog[32];
  int reverb;
};


class FileList {
private:
  struct cell {
    bool done;
    const char* filename;
    Options options;
    cell* next;
  };

  cell* list;
  int index;

public:
  FileList();
  ~FileList();
  void add(const char* filename, Options options);
  const char* get(Options* options);
//void next(void);
  void prev(void);
  void alldone(void);
  void allundone(void);
  const char** getList(void);
  void insert(const char* filename, Options options);
  void clear(void);
//void update(void);

private:
  void write(void);
};

#endif /* !_FILELIST_H_ */
