/*
 * filelist.cc -- file list handling
 *
 * Copyright (C) 1997,1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: filelist.cc,v 1.6 1998-03-25 08:28:00+09 satoshi Exp $
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "filelist.h"
#include "shmem.h"

static const char* filelist = "/tmp/eplaymidi.list";
static const char* tmpfilelist = "/tmp/eplaymidi.list~";

extern volatile Register* reg;

FileList::FileList()
: list(NULL), index(0)
{
  write();
}


FileList::~FileList()
{
  clear();
  unlink(filelist);
  unlink(tmpfilelist);
}


/*
 * add single file to file list
 */
void FileList::add(const char* filename, Options options)
{
  cell* p = list;
  if(p != NULL) {
    for(/**/; p->next != NULL; p = p->next);
    p = p->next = new cell;
  } else
    list = p = new cell;
  p->done = false;
  p->filename = new char[strlen(filename)+1];
  strcpy(p->filename, filename);
  p->options = options;
  p->next = NULL;

  write();
}


/*
 * write the list to the file
 */
void FileList::write(void)
{
#if 0
  FILE* fp;
  if((fp = fopen(tmpfilelist, "w")) == NULL) {
    fprintf(stderr, "%s: ", tmpfilelist);
    perror("fopen");
    return;
  }

  cell* p;
  for(p = list; p != NULL; p = p->next) {
    if(fprintf(fp, "%s\n", p->filename) == 0) {
      fprintf(stderr, "error writing `%s\'.\n", tmpfilelist);
      return;
    }
  }
  fclose(fp);

  if(rename(tmpfilelist, filelist) < 0) {
    perror("rename");
    return;
  }
#endif
}


/*
 * get single file from file list
 */
const char* FileList::get(Options* options)
{
  if(list != NULL) {
    int i;
    cell* p;
    for(i = 0, p = list; i < index; i++, p = p->next);
    for(i = 0; p->done == true && p->next != NULL; i++, p = p->next, index++);
    if(!p->done) {
      *options = p->options;
      p->done = true;
      return p->filename;
    } else
      index = 0;
  }
  return NULL;
}


#if 0
/*
 * next item
 */
void FileList::next(void)
{
  int i;
  cell* p;
  for(i = 0, p = list; i < index; i++, p = p->next);
  if(p->next != NULL)
    index++;
}
#endif


/*
 * previous item
 */
void FileList::prev(void)
{
  if(index > 0) {
    int i;
    cell* p;
    for(i = 0, p = list; i < index; i++, p = p->next);
    p->done = false;
    index--;
    for(i = 0, p = list; i < index; i++, p = p->next);
    p->done = false;
  } else {
    if(list != NULL)
      list->done = false;
  }
}


/*
 * set all files to done
 */
void FileList::alldone(void)
{
  cell* p;
  for(p = list; p != NULL; p = p->next)
    p->done = true;
}


/*
 * set all files to undone
 */
void FileList::allundone(void)
{
  cell* p;
  for(p = list; p != NULL; p = p->next)
    p->done = false;
}


/*
 * get list of filenames
 */
const char** FileList::getList(void)
{
  int i;
  cell* p = list;
  if(list == NULL)
    return NULL;
  for(i = 1; p->next != NULL; i++, p = p->next);
  const char** ret = new const char*[i+1];
  for(i = 0, p = list; p != NULL; i++, p = p->next)
    ret[i] = p->filename;
  ret[i] = NULL;
  return ret;
}


/*
 *
 */
void FileList::insert(const char* filename, Options options)
{
}


/*
 * clear the list
 */
void FileList::clear(void)
{
  if(list != NULL) {
    cell *p, *p1;
    for(p = list; p != NULL; p = p1) {
      delete[] p->filename;
      p1 = p->next;
      delete p;
    }
    list = NULL;
    index = 0;
  }

  write();
}
