/*
 * xmidisel.h -- MIDI file selector
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: xmidisel.h,v 1.2 1998-03-25 08:55:12+09 satoshi Exp $

#ifndef __XMIDISEL_H__
#define __XMIDISEL_H__

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xresource.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Toggle.h>
#include <X11/xpm.h>
#include "menubar.h"
#include "playlist.h"
#include "filelist.h"
#include "server.h"

/*
 * Selector
 */
class Selector {
private:
  Server* server;
  XtAppContext appcontext;
  Display* d;
  XrmDatabase rdb, rdb2;
  Widget toplevel;
  Widget paned;
  MenuBar* mb;
  Widget box1, command1;
  Widget l_playlist;
  PlayList* playlist;
  Widget box2, command2;
  Widget l_filelist;
  FileList* filelist;
  Widget dirBox;
  Widget l_dir;
  Widget dirW;

  Dimension currentWidth, currentHeight;

  const char* name;
  char* wmname;

public:
  Selector(const char *init_dir, int argc, char* argv[], Server* server_);
  ~Selector();
  void main(void);

  const char* getResource(const char* name);
  const char* getResource(const char* class_name, const char* res_name,
			  const char* name2);
  void setResource(const char* line);
  unsigned long allocColor(const char* color);
  void setWMName(const char* name);

private:
//  friend void ResizeCB(void);

  friend void QuitAC(Widget, XEvent*, String*, Cardinal*);
  friend void PlayListAC(Widget, XEvent*, String*, Cardinal*);
  friend void FileListAC(Widget, XEvent*, String*, Cardinal*);
};

#endif // __XMIDISEL_H__
