/*
 * xmidisel.cc -- MIDI file selector
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: xmidisel.cc,v 1.4 1998-04-08 14:50:47+09 satoshi Exp $

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <locale.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xresource.h>
#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Toggle.h>
#include <X11/xpm.h>
#include "kconv.h"
#include "xmidisel.h"

#define CLASS_NAME	"XMidisel"
#define RESOURCE_NAME	"xmidisel"
#define NAME		"xmidisel"	// WM_NAME, WM_ICON_NAME

#define MAX_PATH 1024	/* maximum length of path name */
#define MAX_NAME 255	/* maximum length of file name */

#define PLAYER "eplaymidi"

static void sigcld_handler(int sig);

void QuitAC(Widget, XEvent*, String*, Cardinal*);
void PlayListAC(Widget, XEvent*, String*, Cardinal*);
void FileListAC(Widget, XEvent*, String*, Cardinal*);

inline int max(int x, int y) {
  return (x > y) ? x : y;
}

static String resources[] = {
  CLASS_NAME ".geometry:	640x580",
  //
  "*playList.proportion:	0.2  0.5  0.2  0.1",
  "*fileList.proportion:	0.2  0.5  0.2  0.1",
  CLASS_NAME ".options:",
//CLASS_NAME ".player:	 eplaymidi %s",
  // Xaw3d
  "*beNiceToColormap:	False",
  "*shadowWidth:	2",
  // Fonts
#ifdef KANJI
//"*international: True",
  "*Text*international: False",
  "*FontSet: "
  "  -adobe-helvetica-medium-r-*-*-14-*-*-*-*-*-iso8859-*,"
  "  -jis-fixed-medium-r-normal--16-110-100-100-*-*-jisx0208.1983-*,"
  "  -misc-fixed-medium-r-normal--16-110-100-100-*-*-jisx0201.1976-*",
#endif
  "*font: -adobe-helvetica-medium-r-*-*-14-*-*-*-*-*-iso8859-*",
//"*menubar*font: "
//"  -adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-iso8859-*",
  // Colors
  "*foreground:			black",
  "*background:			gray80",
  "*menubar*background:		#c0c0c0",
  "*paned.background:		gray80",
  "*Scrollbar.foreground:	black",
  "*Scrollbar.background:	gray64",
  "*MList.highlightBackground:	lemon chiffon",
  "*l_playlist.background:	white",
  "*l_filelist.background:	white",
  "*command1.background:	white",
  "*command2.background:	white",
  "*playList*title0.background:	gray60",
  "*playList*title1.background:	gray60",
  "*playList*title2.background:	gray60",
  "*playList*title3.background:	gray60",
  "*fileList*title0.background:	gray60",
  "*fileList*title1.background:	gray60",
  "*fileList*title2.background:	gray60",
  "*fileList*title3.background:	gray60",
  "*playList*show.background:	gray60",
  "*playList*hide.background:	gray60",
  "*fileList*show.background:	gray60",
  "*fileList*hide.background:	gray60",
  "*playList.Grip.foreground:	gray80",
  "*playList.Grip.background:	gray80",
  "*fileList.Grip.foreground:	gray80",
  "*fileList.Grip.background:	gray80",
  // Labels
  "*menubar.FileMenu.label: 	File",
  "*menubar.FileMenu*Open.label: Open",
  "*menubar.FileMenu*Quit.label: Quit",
  "*l_playlist.label:		Play List",
  "*l_filelist.label:		File List",
  "*l_dir.label:		Directory: ",
  "*l_playlist.justify:		Center",
  "*l_filelist.justify:		Center",
  // Translations
  "*translations: #augment "
  "  Alt<Key>Q:		Quit()\\n",
  "*playList*translations: #augment "
  "  Alt<Key>Q:		Quit()\\n"
  "  Ctrl<Key>P:	PlayList(up)\\n"
  "  Ctrl<Key>N:	PlayList(down)\\n"
  "  <Key>Up:		PlayList(up)\\n"
  "  <Key>Down:		PlayList(down)\\n",
  "*playList*Simple*translations: #augment "
  "  Alt<Key>Q:		Quit()\\n"
  "  Ctrl<Key>P:	PlayList(up)\\n"
  "  Ctrl<Key>N:	PlayList(down)\\n"
  "  <Key>Up:		PlayList(up)\\n"
  "  <Key>Down:		PlayList(down)\\n"
  "  <Btn1Down>:	PlayList(select)\\n",
  "*fileList*translations: #augment "
  "  Alt<Key>Q:		Quit()\\n"
  "  Ctrl<Key>P:	FileList(up)\\n"
  "  Ctrl<Key>N:	FileList(down)\\n"
  "  <Key>Up:		FileList(up)\\n"
  "  <Key>Down:		FileList(down)\\n"
  "  <Key>space:	FileList(insert)\\n"
  "  <Key>Return:	FileList(insert)\\n",
  "*fileList*Simple*translations: #augment "
  "  Alt<Key>Q:		Quit()\\n"
  "  Ctrl<Key>P:	FileList(up)\\n"
  "  Ctrl<Key>N:	FileList(down)\\n"
  "  <Key>Up:		FileList(up)\\n"
  "  <Key>Down:		FileList(down)\\n"
  "  <Key>space:	FileList(insert)\\n"
  "  <Key>Return:	FileList(insert)\\n"
  "  <Btn1Down>:	FileList(select)\\n"
  "  <Btn1Down>(2):	FileList(insert)\\n",
  "*fileList*title0.translations: #replace "
  "  <Btn1Down>,<Btn1Up>:	FileList(sort,0,Ascend)\\n"
  "  <Btn3Down>,<Btn3Up>:	FileList(sort,0,Descend)\\n",
  "*fileList*title1.translations: #replace "
  "  <Btn1Down>,<Btn1Up>:	FileList(sort,1,Ascend)\\n"
  "  <Btn3Down>,<Btn3Up>:	FileList(sort,1,Descend)\\n",
  "*fileList*title2.translations: #replace "
  "  <Btn1Down>,<Btn1Up>:	FileList(sort,2,Ascend)\\n"
  "  <Btn3Down>,<Btn3Up>:	FileList(sort,2,Descend)\\n",
  "*fileList*title3.translations: #replace "
  "  <Btn1Down>,<Btn1Up>:	FileList(sort,3,Ascend)\\n"
  "  <Btn3Down>,<Btn3Up>:	FileList(sort,3,Descend)\\n",
  // Miscellaneous
  "*Label.borderWidth:		0",
  "*Label.internalHeight:	0",
  "*Label.internalWidth:	0",
  "*Command.horizDistance:	0",
  "*Command.internalHeight:	0",
  "*Command.internalWidth:	0",
  "*Command.highlightThickness:	0",
  "*box.hSpace:			0",
  "*box.vSpace:			0",
  "*MList.rowSpacing:		4",
  "*MList.internalHeight:	2",
  "*MList.internalWidth:	4",
  "*fileList*list0.height:	200",
  "*fileList*list1.height:	200",
  "*fileList*list2.height:	200",
  "*fileList*list3.height:	200",
  "*playList*list0.height:	200",
  "*playList*list1.height:	200",
  "*playList*list2.height:	200",
  "*playList*list3.height:	200",
  "*playList*list0.justify:	left",
  "*playList*list1.justify:	left",
  "*playList*list2.justify:	center",
  "*playList*list3.justify:	right",
  "*fileList*list0.justify:	left",
  "*fileList*list1.justify:	left",
  "*fileList*list2.justify:	center",
  "*fileList*list3.justify:	right",
  "*dirBox.allowResize:		True",
//"*folderXpm:	/usr/X11/lib/X11/eplaymidi/folder.xpm",
#ifdef Use_Xaw3d
  "*playList.Grip.width:	3",
  "*playList.gripIndent:	0",
  "*fileList.Grip.width:	3",
  "*fileList.gripIndent:	0",
#endif
  NULL
};

static XtActionsRec actions[] = {
  {"Quit",     QuitAC},
  {"PlayList", PlayListAC},
  {"FileList", FileListAC},
};


static Selector* sel = NULL;


Selector::Selector(const char *init_dir, int argc, char* argv[],
		   Server* server_)
: server(server_), name("xmidisel"), wmname(NULL)
{
  sel = this;
  char cur_dir[MAX_PATH+1];
  if(init_dir != NULL) {
    if(init_dir[0] == '/')
      strcpy(cur_dir, init_dir);
    else {
      getcwd(cur_dir, MAX_PATH);
      strcat(cur_dir, "/");
      strcat(cur_dir, init_dir);
    }
  } else
    getcwd(cur_dir, MAX_PATH);

//  setlocale(LC_ALL, "");
  XtSetLanguageProc(NULL, NULL, NULL);

  toplevel = XtVaAppInitialize(&appcontext, CLASS_NAME, NULL, 0, &argc, argv,
			       resources, NULL);

  d = XtDisplay(toplevel);

  char* res = XResourceManagerString(d);
  if(res == NULL)
    rdb = NULL;
  else {
    rdb = XrmGetStringDatabase(res);
    XFree(res);
  }

  rdb2 = XrmGetDatabase(d);
  int i;
  for(i = 0; resources[i] != NULL; i++)
    XrmPutLineResource(&rdb2, resources[i]);

  const char* home_dir;
  char rdbfile[MAX_PATH+MAX_NAME+1];
  if((home_dir = getenv("HOME")) != NULL) {
    sprintf(rdbfile, "%s/.Xdefaults", home_dir);
    XrmCombineFileDatabase(rdbfile, &rdb2, True);
  }

  if(rdb != NULL)
    XrmCombineDatabase(rdb2, &rdb, False);
  else
    rdb = rdb2;
  XrmSetDatabase(d, rdb);

  paned = XtVaCreateManagedWidget("paned", panedWidgetClass, toplevel,
				  NULL);
  mb = new MenuBar(paned);

  box1 = XtVaCreateManagedWidget("box1", panedWidgetClass, paned,
				 XtNborderWidth, 0,
				 XtNorientation, XtEhorizontal,
				 XtNshowGrip,    False,
				 NULL);
  l_playlist = XtVaCreateManagedWidget("l_playlist", labelWidgetClass, box1,
				       XtNshowGrip, False,
				       NULL);
  command1 = XtVaCreateManagedWidget("command1", commandWidgetClass, box1,
				     XtNlabel,    "x",	// ???
				     XtNshowGrip, False,
				     XtNmax,      24,	// ???
				     XtNmin,      24,
				     NULL);
  playlist = new PlayList(server, this, paned, "playList");

  box2 = XtVaCreateManagedWidget("box2", panedWidgetClass, paned,
				 XtNborderWidth, 0,
				 XtNorientation, XtEhorizontal,
				 XtNshowGrip,    False,
				 NULL);
  l_filelist = XtVaCreateWidget("l_filelist", labelWidgetClass, box2,
				XtNshowGrip, False,
				NULL);
  Dimension l_filelist_height;
  XtVaGetValues(l_filelist, XtNheight, &l_filelist_height, NULL);
  command2 = XtVaCreateWidget("command2", commandWidgetClass, box2,
			      XtNlabel,    "x",	// ???
			      XtNshowGrip, False,
			      XtNmax,      24,	// ???
			      XtNmin,      24,
			      NULL);
  Dimension command2_height;
  XtVaGetValues(command2, XtNheight, &command2_height, NULL);
  Widget widget_list[] = { l_filelist, command2 };
  XtManageChildren(widget_list, XtNumber(widget_list));
  filelist = new FileList(this, paned, cur_dir, "fileList", playlist);

  dirBox = XtVaCreateManagedWidget("dirBox", panedWidgetClass, paned,
				   XtNorientation, XtEhorizontal,
				   XtNshowGrip,    False,
				   NULL);
  l_dir = XtVaCreateWidget("l_dir", labelWidgetClass, dirBox,
			   NULL);
  Dimension l_dir_height;
  XtVaGetValues(l_dir, XtNheight, &l_dir_height, NULL);
  dirW = XtVaCreateWidget("dir", asciiTextWidgetClass, dirBox,
			  XtNeditType,     XawtextEdit,
//			  XtNresize,       XawtextResize,
			  XtNwrap,         XawtextWrapNever,
			  XtNdisplayCaret, True,
			  XtNshowGrip,     False,
			  NULL);
  Dimension dirW_height;
  XtVaGetValues(dirW, XtNheight, &dirW_height, NULL);
  Widget widget_list2[] = { l_dir, dirW };
  XtManageChildren(widget_list2, XtNumber(widget_list));
  XtAppAddActions(appcontext, actions, XtNumber(actions));
  XtRealizeWidget(toplevel);

  XawPanedSetMinMax(box2, l_filelist_height, l_filelist_height);
  XawPanedSetMinMax(dirBox, l_dir_height, l_dir_height);

#if 0
  Dimension h;
  XtVaGetValues(l_filelist, XtNheight, &h, NULL);
  XawPanedSetMinMax(l_filelist, h, h);
#endif

  playlist->initialize();
  filelist->initialize();
}


Selector::~Selector()
{
  delete filelist;
  delete playlist;
  delete mb;
  XtDestroyApplicationContext(appcontext);
  exit(EXIT_SUCCESS);
}


/*
 * main loop
 */
void Selector::main(void)
{
  signal(SIGCHLD, sigcld_handler);
  XtAppMainLoop(appcontext);
}


/*
 * get resource
 */
const char* Selector::getResource(const char* name)
{
  char rname[80];
  char cname[80];
  sprintf(rname, "%s.%s", RESOURCE_NAME, name);
  sprintf(cname, "%s.%s", CLASS_NAME, name);
  // resource name is just lowercased name of its class name.
  int i;
  for(i = 0; rname[i] != '\0'; i++)
    rname[i] = tolower(rname[i]);
  char* type;
  XrmValue value;
  if(XrmGetResource(rdb, rname, cname, &type, &value))
    return value.addr;
  else
    return "";
}


/*
 * get resource
 */
const char* Selector::getResource(const char* class_name, const char* res_name,
				  const char* name)
{
  char rname[80];
  char cname[80];
  sprintf(rname, "%s.%s.%s", RESOURCE_NAME, res_name, name);
  sprintf(cname, "%s.%s.%s", CLASS_NAME, class_name, name);
  // resource name is just lowercased name of its class name. ???
  int i;
  for(i = strrchr(rname, '.')-rname; rname[i] != '\0'; i++)
    rname[i] = tolower(rname[i]);
  char* type;
  XrmValue value;
  if(XrmGetResource(rdb, rname, cname, &type, &value))
    return value.addr;
  else
    return "";
}


/*
 * set resource
 */
void Selector::setResource(const char* line)
{
  XrmPutLineResource(&rdb, line);
}


/*
 * allocate named color
 */
unsigned long Selector::allocColor(const char* color)
{
  Colormap cmap;
  XColor c0, c1;
  cmap = DefaultColormap(XtDisplay(toplevel), 0);
  XAllocNamedColor(XtDisplay(toplevel), cmap, color, &c1, &c0);
  return(c1.pixel);
}


/*
 * set WM_NAME property
 */
void Selector::setWMName(const char* name)
{
  char* wmname = new char[strlen(NAME)+1+strlen(name)+1];
  sprintf(wmname, "%s: %s", NAME, name);
  XSetIconName(XtDisplay(toplevel), XtWindow(toplevel), wmname);
  XStoreName(XtDisplay(toplevel), XtWindow(toplevel), wmname);
}


/*
 * SIGCLD handler
 */
static void sigcld_handler(int sig)
{
  (void) sig;
  if(wait(NULL) == -1)
    perror("wait");
  signal(SIGCHLD, sigcld_handler);
}


/*
 *
 */
void QuitAC(Widget, XEvent*, String*, Cardinal*)
{
  delete sel;
}


#if 0
void ResizeCB(void)
{
  Dimension w, h;
  XtVaGetValues(sel->paned,
		XtNwidth,  &w,
		XtNheight, &h,
		NULL);
  if(w != sel->currentWidth || h != sel->currentHeight) {


    sel->currentWidth = w;
    sel->currentHeight = h;
  }
}
#endif


void FileListAC(Widget w, XEvent* event, String* params, Cardinal* num)
{
  if(num == 0)
    return;
  if(!strcmp("up", params[0])) {
    sel->filelist->listW->up();
  }
  if(!strcmp("down", params[0])) {
    sel->filelist->listW->down();
  }
  if(!strcmp("select", params[0])) {
    XButtonEvent* e = &(event->xbutton);
    if(e->type == ButtonPress)
      sel->filelist->listW->select(e->x, e->y, false);
  }
  if(!strcmp("insert", params[0])) {
    XButtonEvent* e = &(event->xbutton);
    if(e->type == ButtonPress) {
      sel->filelist->listW->select(e->x, e->y, true);
      sel->filelist->select(sel->filelist->listW->cur_file);
    } else
      sel->filelist->select(sel->filelist->listW->cur_file);
  }
  if(!strcmp("sort", params[0])) {
    if(*num < 3)
      return;
    bool order = !strcasecmp("ascend", params[2]);
    sel->filelist->sort(atoi(params[1]), order);
  }
}


void PlayListAC(Widget w, XEvent* event, String* params, Cardinal* num)
{
  if(num == 0)
    return;
  if(!strcmp("up", params[0])) {
    sel->playlist->listW->up();
  }
  if(!strcmp("down", params[0])) {
    sel->playlist->listW->down();
  }
  if(!strcmp("select", params[0])) {
    XButtonEvent* e = &(event->xbutton);
    if(e->type == ButtonPress)
      sel->playlist->listW->select(e->x, e->y, false);
  }
  if(!strcmp("sort", params[0])) {
    if(*num < 3)
      return;
    bool order = !strcasecmp("ascend", params[2]);
//    sel->playlist->sort(atoi(params[1]), order);
  }
}
