/*
 * playlist.cc -- play list
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: playlist.cc,v 1.2 1998-03-25 08:54:31+09 satoshi Exp $

#include "playlist.h"
#include "xmidisel.h"
#include "server.h"


static const unsigned long sleep_time = 100;	// in milliseconds


PlayList::PlayList(Server* server_, Selector* sel_, Widget parent_,
		   const char* name)
: server(server_), sel(sel_), parent(parent_)
{
  const char* titles[] = {"File", "Title", "Date", "Size"};
  listW = new MList(sel, parent, name, 4, titles);	// ???
}


/*
 * intialization
 */
void PlayList::initialize(void)
{
  listW->initialize();
  XtAppAddTimeOut(XtWidgetToApplicationContext(parent),
		  sleep_time, &timer, this);
  seqid = server->creg->reg->seqid;
  update();
}


PlayList::~PlayList()
{
}


/*
 * update play list
 */
void PlayList::update(void)
{
  fileinfo.erase(fileinfo.begin(), fileinfo.end());

  char** plist;
  if((plist = server->getList()) != NULL) {
    int size;
    for(size = 0; plist[size] != NULL; size++);
    const char** newlist = new const char*[size*4];
    int i;
    back_insert_iterator<list<FileInfo> > bit(fileinfo);
    for(i = 0; i < size; i++) {
      *bit++ = *(new FileInfo(plist[i]));
      delete[] plist[i];
    }
    delete[] plist;
    list<FileInfo>::iterator it;
    for(it = fileinfo.begin(), i = 0; it != fileinfo.end(); it++, i++) {
      newlist[0*size+i] = it->getName();
      newlist[1*size+i] = it->getTitle();
      newlist[2*size+i] = it->getDateStr();
      newlist[3*size+i] = it->getSizeStr();
    }
    listW->change(size, newlist, NULL);
  }
}


/*
 * sort
 */
void PlayList::sort()
{
}


/*
 * set insert position
 */
void PlayList::setInsertPos()
{
}


/*
 * insert a file into play list
 */
void PlayList::insert(const FileInfo& finfo)
{
  const char* res_options = sel->getResource("options");
  const char* filename = finfo.getPath();
  char* options = strdup(res_options);
  const char* argv[256];
  int i = 0, j = 0;
  for(;;) {
    while(options[i++] == ' ');
    if(options[i-1] == '\0') {
      argv[j] = NULL;
      break;
    }
    argv[j++] = &options[i-1];
    if(j > 255) {
      fprintf(stderr, "too many arguments\n");
      argv[255] = NULL;
      break;
    }
    while(options[i] != ' ' && options[i] != '\0') i++;
    if(options[i] == '\0') {
      argv[j] = NULL;
      break;
    } else
      options[i++] = '\0';
  }
  server->add(filename, argv);
  delete[] options;

#if 0
  pid_t pid;
  switch((pid = fork())) {
  case 0: // child process
    {
      const char* res_player = sel->getResource("player");
      const char* filename = finfo.getPath();
      char* command = new char[strlen(res_player)+strlen(filename)];
      sprintf(command, res_player, (const char*)filename);
      char* argv[256];
      int i = 0, j = 0;
      for(;;) {
	while(command[i++] == ' ');
	argv[j++] = &command[i-1];
	if(j > 255) {
	  fprintf(stderr, "too many arguments\n");
	  exit(EXIT_FAILURE);
	}
	while(command[i] != ' ' && command[i] != '\0') i++;
	if(command[i] == '\0') {
	  argv[j] = NULL;
	  break;
	} else
	  command[i++] = '\0';
      }
      if(execvp(argv[0], argv) == -1) {
	perror("execvp");
	exit(EXIT_FAILURE);
      }
    }
    break;
  case -1: // error
    perror("fork");
    break;
  default: // parent process
    break;
  }
#endif
}


/*
 * interval timer
 */
void timer(PlayList* self, XtIntervalId* /*id*/)
{
  volatile Register* reg = self->server->creg->reg;
  unsigned long seqid = reg->seqid;
  if(seqid != self->seqid) {
    self->seqid = seqid;
    self->update();
  }
  XtAppAddTimeOut(XtWidgetToApplicationContext(self->parent),
		  sleep_time, &timer, self);
}
