/*
 * filelist.h -- file list
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: filelist.h,v 1.3 1998-03-25 08:40:06+09 satoshi Exp $

#ifndef __FILELIST_H__
#define __FILELIST_H__

#include <X11/Intrinsic.h>
#include <list.h>
#include "dir.h"
#include "mlist.h"
#include "fileinfo.h"
#include "playlist.h"

class Selector;

/*
 * FileList
 */
class FileList {
private:
  Selector* sel;
  Widget parent;
  MList* listW;
  PlayList* playlist;

  Directory dir;
  list<FileInfo> fileinfo;

  enum sort_type { sort_name, sort_title, sort_date, sort_size };
  sort_type sort_by;
  bool sort_order;	// true: ascending, false: descending

public:
  FileList(Selector* sel_, Widget parent_, const char* path_,
	   const char* name, PlayList* playlist_);
  ~FileList();

  void initialize(void);
  void change(void);
  void select(int n);
  void updir();
  void sort(sort_type s);
  void sort(int s, bool order);

private:
  void _sort(void);

  friend void FileListAC(Widget, XEvent*, String*, Cardinal*);
};

#endif // __FILELIST_H__
