/*
 * fileinfo.h -- file information
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: fileinfo.h,v 1.2 1998/03/14 10:57:58 satoshi Exp $

#ifndef __FILEINFO_H__
#define __FILEINFO_H__

#include <time.h>

class FileInfo {
private:
  char* path;
  char* name;
  char* title;
  time_t date;
  unsigned long size;
  enum file_type {Unknown, Dir, RCP, RCP3, SMF} type;
//  bool is_played;

public:
  FileInfo(const char* path_);
  ~FileInfo();

  bool isdirectory(void) const
    { return type == Dir; }
  bool ismidifile(void) const
    { return (type == RCP) || (type == RCP3) || (type == SMF); }
  const char* getPath(void) const
    { return path; }
  const char* getName(void) const
    { return name; }
  const char* getTitle(void) const
    { return (type == Dir) ? "<Directory>" : title; }
  time_t getDate(void) const
    { return date; }
  const char* getDateStr(void) const;
  unsigned long getSize(void) const
    { return (type == Dir) ? 0 : size; }
  const char* getSizeStr(void) const;

private:
  file_type _isdirectory(void);
  file_type _ismidifile(void);
  void _getTitle(void);

public:
  enum Order { ascend, descend };
  friend bool compare_name_a(const FileInfo& f1, const FileInfo& f2);
  friend bool compare_name_d(const FileInfo& f1, const FileInfo& f2);
  friend bool compare_title_a(const FileInfo& f1, const FileInfo& f2);
  friend bool compare_title_d(const FileInfo& f1, const FileInfo& f2);
  friend bool compare_date_a(const FileInfo& f1, const FileInfo& f2);
  friend bool compare_date_d(const FileInfo& f1, const FileInfo& f2);
  friend bool compare_size_a(const FileInfo& f1, const FileInfo& f2);
  friend bool compare_size_d(const FileInfo& f1, const FileInfo& f2);
  friend bool compare_dir(const FileInfo& f1, const FileInfo& f2, bool* r);
};

#endif // __FILEINFO_H__
