/*
 * dir.h -- Directory
 *
 * Copyright (C) 1996-1998 Satoshi KURAMOCHI <satoshi@ueda.info.waseda.ac.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// $Id: dir.h,v 1.2 1998/03/14 10:55:46 satoshi Exp $

#ifndef __DIR_H__
#define __DIR_H__

#include <list.h>
#include "fileinfo.h"

/*
 * Directory
 */
class Directory {
private:
  char* path;

public:
  Directory(const char* path_);
  ~Directory();

  const char* getPath(void) const
    { return path; }
  list<FileInfo>& read(void);
  void open(const char* path_);
  void up(void);
  void down(const char* dir_);

  void setFilter();
  void rescan();
};

#endif // __DIR_H__
